% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{ImageFeaturePlot}
\alias{ImageFeaturePlot}
\title{Spatial Feature Plots}
\usage{
ImageFeaturePlot(
  object,
  features,
  fov = NULL,
  boundaries = NULL,
  cols = if (isTRUE(x = blend)) {
     c("lightgrey", "#ff0000", "#00ff00")
 } else {
   
     c("lightgrey", "firebrick1")
 },
  size = 0.5,
  min.cutoff = NA,
  max.cutoff = NA,
  split.by = NULL,
  molecules = NULL,
  mols.size = 0.1,
  mols.cols = NULL,
  nmols = 1000,
  alpha = 1,
  border.color = "white",
  border.size = NULL,
  dark.background = TRUE,
  blend = FALSE,
  blend.threshold = 0.5,
  crop = FALSE,
  cells = NULL,
  scale = c("feature", "all", "none"),
  overlap = FALSE,
  axes = FALSE,
  combine = TRUE,
  coord.fixed = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Vector of features to plot. Features can come from:
\itemize{
  \item An \code{Assay} feature (e.g. a gene name - "MS4A1")
  \item A column name from meta.data (e.g. mitochondrial percentage -
    "percent.mito")
  \item A column name from a \code{DimReduc} object corresponding to the
    cell embedding values (e.g. the PC 1 scores - "PC_1")
}}

\item{fov}{Name of FOV to plot}

\item{boundaries}{A vector of segmentation boundaries per image to plot;
can be a character vector, a named character vector, or a named list.
Names should be the names of FOVs and values should be the names of
segmentation boundaries}

\item{cols}{The two colors to form the gradient over. Provide as string vector with
the first color corresponding to low values, the second to high. Also accepts a Brewer
color scale or vector of colors. Note: this will bin the data into number of colors provided.
When blend is \code{TRUE}, takes anywhere from 1-3 colors:
\describe{
  \item{1 color:}{Treated as color for double-negatives, will use default colors 2 and 3 for per-feature expression}
  \item{2 colors:}{Treated as colors for per-feature expression, will use default color 1 for double-negatives}
  \item{3+ colors:}{First color used for double-negatives, colors 2 and 3 used for per-feature expression, all others ignored}
}}

\item{size}{Point size for cells when plotting centroids}

\item{min.cutoff, max.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10')}

\item{split.by}{A factor in object metadata to split the plot by, pass 'ident'
to split by cell identity'}

\item{molecules}{A vector of molecules to plot}

\item{mols.size}{Point size for molecules}

\item{mols.cols}{A vector of color for molecules. The "Set1" palette from
RColorBrewer is used by default.}

\item{nmols}{Max number of each molecule specified in `molecules` to plot}

\item{alpha}{Alpha value for plotting (default is 1)}

\item{border.color}{Color of cell segmentation border; pass \code{NA}
to suppress borders for segmentation-based plots}

\item{border.size}{Thickness of cell segmentation borders; pass \code{NA}
to suppress borders for centroid-based plots}

\item{dark.background}{Set plot background to black}

\item{blend}{Scale and blend expression values to visualize coexpression of two features}

\item{blend.threshold}{The color cutoff from weak signal to strong signal; ranges from 0 to 1.}

\item{crop}{Crop the plots to area with cells only}

\item{cells}{Vector of cells to plot (default is all cells)}

\item{scale}{Set color scaling across multiple plots; choose from:
\itemize{
 \item \dQuote{\code{feature}}: Plots per-feature are scaled across splits
 \item \dQuote{\code{all}}: Plots per-feature are scaled across all features
 \item \dQuote{\code{none}}: Plots are not scaled; \strong{note}: setting
  \code{scale} to \dQuote{\code{none}} will result in color scales that are
  \emph{not} comparable between plots
}
Ignored if \code{blend = TRUE}}

\item{overlap}{Overlay boundaries from a single image to create a single
plot; if \code{TRUE}, then boundaries are stacked in the order they're
given (first is lowest)}

\item{axes}{Keep axes and panel background}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}

\item{coord.fixed}{Plot cartesian coordinates with fixed aspect ratio}
}
\value{
If \code{combine = TRUE}, a \code{patchwork}
ggplot object; otherwise, a list of ggplot objects
}
\description{
Visualize expression in a spatial context
}
\concept{spatial}
\concept{visualization}
