% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{CreateSCTAssayObject}
\alias{CreateSCTAssayObject}
\title{Create a SCT Assay object}
\usage{
CreateSCTAssayObject(
  counts,
  data,
  scale.data = NULL,
  umi.assay = "RNA",
  min.cells = 0,
  min.features = 0,
  SCTModel.list = NULL
)
}
\arguments{
\item{counts}{Unnormalized data such as raw counts or TPMs}

\item{data}{Prenormalized data; if provided, do not pass \code{counts}}

\item{scale.data}{a residual matrix}

\item{umi.assay}{The UMI assay name. Default is RNA}

\item{min.cells}{Include features detected in at least this many cells. Will
subset the counts matrix as well. To reintroduce excluded features, create a
new object with a lower cutoff.}

\item{min.features}{Include cells where at least this many features are
detected.}

\item{SCTModel.list}{list of SCTModels}
}
\description{
Create a SCT object from a feature (e.g. gene) expression matrix and a list of SCTModels.
The expected format of the input matrix is features x cells.
}
\details{
Non-unique cell or feature names are not allowed. Please make unique before
calling this function.
}
\concept{objects}
