% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{CreateGeneActivityMatrix}
\alias{CreateGeneActivityMatrix}
\title{Convert a peak matrix to a gene activity matrix}
\usage{
CreateGeneActivityMatrix(peak.matrix, annotation.file,
  seq.levels = c(1:22, "X", "Y"), include.body = TRUE,
  upstream = 2000, downstream = 0, verbose = TRUE)
}
\arguments{
\item{peak.matrix}{Matrix of peak counts}

\item{annotation.file}{Path to GTF annotation file}

\item{seq.levels}{Which seqlevels to keep (corresponds to chromosomes usually)}

\item{include.body}{Include the gene body?}

\item{upstream}{Number of bases upstream to consider}

\item{downstream}{Number of bases downstream to consider}

\item{verbose}{Print progress/messages}
}
\description{
This function will take in a peak matrix and an annotation file (gtf) and collapse the peak
matrix to a gene activity matrix. It makes the simplifying assumption that all counts in the gene
body plus X kb up and or downstream should be attributed to that gene.
}
