% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{DimTopCells}
\alias{DimTopCells}
\title{Find cells with highest scores for a given dimensional reduction technique}
\usage{
DimTopCells(object, dim.use = 1, reduction.type = "pca", num.cells = NULL,
  do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{dim.use}{Components to use}

\item{reduction.type}{Dimensional reduction to find the highest score for}

\item{num.cells}{Number of cells to return}

\item{do.balanced}{Return an equal number of cells with both + and - scores.}
}
\value{
Returns a vector of cells
}
\description{
Return a list of genes with the strongest contribution to a set of components
}
\examples{
pbmc_small
head(DimTopCells(object = pbmc_small, reduction.type = "pca"))
# Can specify which dimension and how many cells to return
DimTopCells(object = pbmc_small, reduction.type = "pca", dim.use = 2, num.cells = 5)

}
