% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_postmean_Cauchy}
\alias{SSS_postmean_Cauchy}
\title{Compute posterior means of data points for the Cauchy(gamma) slab}
\usage{
SSS_postmean_Cauchy(x, logpsi, postprobs, sigma, gamma)
}
\arguments{
\item{x}{Data vector of length n}

\item{logpsi}{Vector of length n that represents a preprocessed version of the data.
It should contain the logs of the psi densities of the data points, as produced 
by \code{\link{SSS_log_phi_psi_Cauchy}}.}

\item{postprobs}{Vector of marginal posterior slab probabilities that \eqn{x[i]} has
non-zero mean for \eqn{i=1,...,n}.}

\item{sigma}{standard deviation of observations}

\item{gamma}{parameter of Cauchy slab density}
}
\value{
Vector of n posterior means
}
\description{
Compute posterior means of data points for the Cauchy(gamma) slab
}
