\name{panellipse.session}
\alias{panellipse.session}

\title{Repetability of panelists descriptions studied by confidence ellipses around products per session}

\description{Virtual panels are generated using Boostrap techniques in order to display
confidence ellipses around products.}

\usage{
panellipse.session(donnee, col.p, col.j, col.s, firstvar, 
    lastvar = ncol(donnee), alpha = 0.05, coord = c(1,2), 
    scale.unit = TRUE, nbsimul = 500, nbchoix = NULL, 
    level.search.desc = 0.2,  centerbypanelist = TRUE, 
    scalebypanelist = FALSE, name.panelist = FALSE,
    variability.variable = FALSE, cex = 1, color= NULL)
}

\arguments{
  \item{donnee}{a data frame made up of at least two qualitative variables 
  (\emph{product}, \emph{panelist}) and a set of quantitative variables (sensory descriptors)}  
  \item{col.p}{the position of the \emph{product} variable}
  \item{col.j}{the position of the \emph{panelist} variable}
  \item{col.s}{the position of the \emph{session} variable}
  \item{firstvar}{the position of the first sensory descriptor}
  \item{lastvar}{the position of the last sensory descriptor (by default the last column of \code{donnee})}
  \item{alpha}{the confidence level of the ellipses}
  \item{coord}{a length 2 vector specifying the components to plot}
  \item{scale.unit}{boolean, if T the descriptors are scaled to unit variance}
  \item{nbsimul}{the number of simulations (corresponding to the number of virtual panels) used to compute the ellipses}
  \item{nbchoix}{the number of panelists forming a virtual panel, by default the number of panelists in the original panel}  
  \item{level.search.desc}{the threshold above which a descriptor is not considered as discriminant according to AOV model \code{"descriptor=Product+Panelist"}}
  \item{centerbypanelist}{boolean, if T center the data by panelist before the construction of the axes}
  \item{scalebypanelist}{boolean, if T scale the data by panelist before the construction of the axes (by default, FALSE
  is assigned to that parameter)}
  \item{name.panelist}{boolean, if T then the name of each panelist is displayed on the \code{plotpanelist} graph (by default, FALSE
  is assigned to that parameter)}
  \item{variability.variable}{boolean, if T a plot with the variability of the variable is drawn and a confidence intervals of the correlations
  between descriptors are calculated}
  \item{cex}{cf. function \code{\link{par}} in the \pkg{graphics} package}
  \item{color}{a vector with the colors used; by default there are 35 colors defined}
}


\details{
panellipse.session, step by step:\cr
Step 1 Construct a data frame by session \cr
Step 2 Performs a selection of discriminating descriptors with respect to a threshold set by users \cr
Step 3 MFA is computed with one group for one session \cr
Step 4 Virtual panels are generated using Boostrap techniques; the number of panels as well as their size
are set by users with the \emph{nbsimul} and \emph{nbchoix} parameters \cr
Step 5 Coordinates of the products with respect to each virtual panels are computed \cr
Step 6 Each product is then circled by its confidence ellipse generated by virtual panels and
comprising (1-alpha)*100 percent of the virtual products
}
\value{
A list containing the following elements:
  \item{bysession}{the data by session}
  \item{eig}{a matrix with the component of the factor analysis (in row) and the eigenvalues, the inertia and the cumulative inertia for each component}
  \item{coordinates}{a list with: the coordinates of the products with respect to the panel and to each panelists
 and the coordinates of the \emph{partial} products with respect to the panel and to each panelists}
  \item{hotelling}{returns a matrix with the P-values of the Hotelling's T2 tests for each pair of products: this matrix allows to find the
product which are significatnly different for the 2-components sensory description}
  \item{variability}{returns an index of the sessions' reproductibility: the first eigenvalue of the separate PCA performed on homologous descriptors}

Returns a graph of the products as well as a correlation circle of the descriptors.\cr

Returns a graph where each product is displayed with respect to a panel and to each panelist composing
the panel; products described by the panel are displayed as square, they are displayed as circle when
they are described by each panelist.\cr

Returns a graph where each product is circled by its confidence ellipse generated by virtual panels.\cr

Returns a graph where each partial product is circled by its confidence ellipse generated by virtual panels.\cr

Returns a graph where the variability of each variable is drawn on the correlation circle graph. \cr

}

\seealso{\code{\link{panellipse}}}

\references{
Husson F., Le Dien S. & Pages J.  (2005). Confidence ellipse for the sensory profiles obtained by Principal Components Analysis. \emph{Food Quality and Preference}.  16 (3), 245-250. \cr
Pages J. & Husson F. (2005). Multiple Factor Analysis with confidence ellipses: a methodology to study the relationships between sensory and instrumental data. To be published in \emph{Journal of Chemometrics}. \cr
Husson F., Le S. & Pages J.  Variability of the representation of the variables resulting from PCA in the case of a conventional sensory profile. \emph{Food Quality and Preference}.  16 (3), 245-250. 
}
\author{
F Husson, S Le}

\examples{
\dontrun{
data(chocolates)
res <- panellipse.session(sensochoc, col.p = 4, col.j = 1, col.s = 2, 
    firstvar = 5)
magicsort(res$variability)
for (i in 1:dim(res$hotelling$bysession)[3]) coltable(res$hotelling$bysession[,,i], 
    main.title = paste("P-values for the Hotelling's T2 tests (",
    dimnames(res$hotelling$bysession)[3][[1]][i],")",sep=""))
}
}
\keyword{multivariate}
