% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoConverge.R
\name{autoConverge}
\alias{autoConverge}
\title{Autmated Converge Responses}
\usage{
autoConverge(rmat)
}
\arguments{
\item{rmat}{A \link[SemNetCleaner]{textcleaner} filtered response matrix}
}
\value{
A list containing four objects:

\item{rmat}{A response matrix that has had responses converged}

\item{converged}{A matrix of responses showing the original response (from) and
the response that replaced it (to). If response was not converged, then it stays the same}
\item{changed}{A matrix of responses that were changed. The original response (from)
and the response that replaced it (to). If responses were removed, then <NA> is displayed}

\item{participant}{A list of each response with each participant affected}
}
\description{
Automated \link[SemNetCleaner]{converge} function merging of columns of binarized response data with another
}
\examples{
\donttest{
#text cleaned
clean <- textcleaner(rmat)

#Automated converge
convmat <- autoConverge(clean)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
