% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2cytoscape.R
\name{convert2cytoscape}
\alias{convert2cytoscape}
\title{Convert Adjacency Matrix to Cytoscape Format}
\usage{
convert2cytoscape(A)
}
\arguments{
\item{A}{A cleaned, finalized response matrix ready to be visualized}
}
\value{
A sparse matrix formatted for Cytoscape
}
\description{
Converts an adjacency matrix to Cytoscape's sparse matrix format
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)
#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB

#compute similarity matrix
cosC <- cosine(eqCmat)
cosR <- cosine(eqRmat)

#compute networks using NetworkToolbox
Cnet <- NetworkToolbox::TMFG(cosC)$A
Rnet <- NetworkToolbox::TMFG(cosR)$A

#covert to Cytoscape format
ctyoC <- convert2cytoscape(Cnet)
ctyoR <- convert2cytoscape(Rnet)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
