% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{grofman}
\alias{grofman}
\title{Grofman Index}
\usage{
grofman(v, s, ...)

grofman(v, s, ...)
}
\arguments{
\item{v}{A numeric vector of data values for votes each political party obtained.}

\item{s}{A numeric vector of data values for seats each political party obtained, the election outcome as seats.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A single score given the votes each party received and seats obtained.
}
\description{
Calculates the Grofman index of proportionality based on a vector of votes and a vector for the electoral outcome.
}
\examples{
# 2012 Quebec provincial election:
pvotes = c(PQ=31.95, Lib=31.20, CAQ=27.05,QS=6.03,Option=1.89, Other=1.88)
pseats = c(PQ=54, Lib=50, CAQ=19, QS=2, Option=0, Other=0)

grofman(pvotes, pseats)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\references{
Taagepera, R., and B. Grofman. Mapping the indices of seats-votes disproportionality and inter-election volatility. Party Politics 9, no. 6 (2003): 659-77.
}
\seealso{
\code{\link{cox.shugart}}, \code{\link{inv.cox.shugart}}, \code{\link{politicalDiversity}}, \code{\link{farina}}, \code{\link{gallagher}},  \code{\link{lijphart}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}
}

