% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggFootnote.R
\encoding{UTF-8}
\name{ggFootnote}
\alias{ggFootnote}
\title{Add Footnote to a ggplot Object}
\usage{
ggFootnote(x = NULL, size = NULL, color = NULL, rotation = 90,
  justification = c("right", "bottom"))
}
\arguments{
\item{x}{any text or empty to use default.}

\item{size}{the font size \code{x}.}

\item{color}{the color for \code{x}.}

\item{rotation}{the rotation for the footnote, default is \code{rotation=90}.}

\item{justification}{the justification method.}
}
\description{
Add footnotes to \pkg{ggplot2} objects.
}
\details{
At this stage, this function only works for a ggplot object.
}
\examples{
# setup data
x <- seq(0, 50, 1)
supply <- x * -2 + 100
demand <- x * 2
df <- data.frame( x = x, supply=supply, demand=demand)

library(ggplot2)
ggplot(df, aes(x)) +
geom_line(aes(y = supply, colour = supply))+
geom_line(aes(y = demand, colour = demand))
ggFootnote(size = .9, color = "red")
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Graphs}

