% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overplot.R
\name{overplot}
\alias{overplot}
\alias{overplot.swmpr}
\alias{overplot.default}
\title{Plot multiple SWMP time series on the same y-axis}
\usage{
overplot(dat_in, ...)

\method{overplot}{swmpr}(
  dat_in,
  select = NULL,
  subset = NULL,
  operator = NULL,
  ylabs = NULL,
  xlab = NULL,
  cols = NULL,
  lty = NULL,
  lwd = NULL,
  pch = NULL,
  type = NULL,
  ...
)

\method{overplot}{default}(
  dat_in,
  date_var,
  select = NULL,
  ylabs = NULL,
  xlab = NULL,
  cols = NULL,
  lty = NULL,
  lwd = NULL,
  inset = -0.15,
  cex = 1,
  xloc = "top",
  yloc = NULL,
  pch = NULL,
  type = NULL,
  ...
)
}
\arguments{
\item{dat_in}{input data object}

\item{...}{additional arguments passed to \code{\link[graphics]{plot}}}

\item{select}{chr string of variable(s) to plot, passed to \code{\link{subset}}.  This is a required argument for the default method.}

\item{subset}{chr string of form 'YYYY-mm-dd HH:MM' to subset a date range. Input can be one (requires operator or two values (a range).  Passed to \code{\link{subset}}.}

\item{operator}{chr string specifiying binary operator (e.g., '>', '<=') if subset is one date value, passed to \code{\link{subset}}}

\item{ylabs}{chr string of labels for y-axes, default taken from \code{select} argument}

\item{xlab}{chr string of label for x-axis}

\item{cols}{chr string of colors to use for lines}

\item{lty}{numeric indicating line types, one value for all or values for each parameter}

\item{lwd}{numeric indicating line widths, one value for all or values for each parameter, used as \code{cex} for point size if \code{type = 'p'}}

\item{pch}{numeric for point type of points are used}

\item{type}{character string indicating \code{'p'} or \code{'l'} for points or lines, as a single value for all parameters or a combined vector equal in length to the number of parameters}

\item{date_var}{chr string of the name for the datetimestamp column, not required for \code{\link{swmpr}} objects}

\item{inset}{numeric of relative location of legend, passed to \code{\link[graphics]{legend}}}

\item{cex}{numeric of scale factor for legend, passed to \code{\link[graphics]{legend}}}

\item{xloc}{x location of legend, passed to \code{\link[graphics]{legend}}}

\item{yloc}{y location of legend, passed to \code{\link[graphics]{legend}}}
}
\value{
An R plot created using base graphics
}
\description{
Plot multiple SWMP time series on the same y-axis, aka overplotting
}
\details{
One to many SWMP parameters can be plotted on the same y-axis to facilitate visual comparison.  This is commonly known as overplotting.  The building blocks of this function include \code{\link[graphics]{plot}}, \code{\link[graphics]{legend}}, \code{\link[graphics]{axis}}, and \code{\link[graphics]{mtext}}.
}
\examples{
## import data
data(apacpwq)
dat <- qaqc(apacpwq)

## plot
overplot(dat)

## a truly heinous plot
overplot(dat, select = c('depth', 'do_mgl', 'ph', 'turb'), 
 subset = c('2013-01-01 0:0', '2013-02-01 0:0'), lwd = 2)
 
\dontrun{
## change the type argument if plotting discrete and continuous data
swmp1 <- apacpnut
swmp2 <- apaebmet
dat <- comb(swmp1, swmp2, timestep = 120, method = 'union')
overplot(dat, select = c('chla_n', 'atemp'), subset = c('2012-01-01 0:0', '2013-01-01 0:0'), 
 type = c('p', 'l'))
}
}
\seealso{
\code{\link{subset}}
}
\concept{analyze}
