% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\name{decompTs}
\alias{decompTs}
\title{Decompose a time series}
\usage{
decompTs(x, event = TRUE, type = c("add", "mult"), center = c("mean",
  "median"))
}
\arguments{
\item{x}{a monthly time series vector}

\item{event}{whether or not an "events" component should be determined}

\item{type}{the type of decomposition, either multiplicative ("mult") or additive ("add")}

\item{center}{the method of centering, either median or mean}
}
\value{
A monthly time series matrix with the following individual time series:
\item{original }{original time series}
\item{annual }{annual mean series}
\item{seasonal }{repeating seasonal component}
\item{events }{optionally, the residual or "events" series}
}
\description{
The function decomposes a time series into a long-term mean, annual, seasonal and "events" component. The decomposition can be multiplicative or additive, and based on median or mean centering. Function and documentation herein are from archived wq package.
}
\details{
The rationale for this simple approach to decomposing a time series, with examples of its application, is given by Cloern and Jassby (2010). It is motivated by the observation that many important events for estuaries (e.g., persistent dry periods, species invasions) start or stop suddenly. Smoothing to extract the annualized term, which can disguise the timing of these events and make analysis of them unnecessarily difficult, is not used.

A multiplicative decomposition will typically be useful for a biological community- or population-related variable (e.g., chlorophyll-a) that experiences exponential changes in time and is approximately lognormal, whereas an additive decomposition is more suitable for a normal variable. The default centering method is the median, especially appropriate for series that have large, infrequent events.

If \code{event = TRUE}, the seasonal component represents a recurring monthly pattern and the events component a residual series. Otherwise, the seasonal component becomes the residual series. The latter is appropriate when seasonal patterns change systematically over time.
}
\references{
Cloern, J.E. and Jassby, A.D. (2010) Patterns and scales of phytoplankton variability in estuarine-coastal ecosystems. \emph{Estuaries and Coasts} \bold{33,} 230--241.
}
\seealso{
\code{\link{decomp_cj}}
}

