/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class HashTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public HashTable() {
        this.table = new Entry[11];
    }

    public HashTable(int n) {
        this.table = new Entry[n];
    }

    public HashTable(HashTable hashTable) {
        this.count = hashTable.count;
        this.table = new Entry[hashTable.table.length];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = hashTable.table[n];
            Entry entry2 = null;
            if (entry != null) {
                this.table[n] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
                while (entry != null) {
                    entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                    entry = entry.next;
                }
            }
            ++n;
        }
    }

    public int size() {
        return this.count;
    }

    public Object get(Object object) {
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key.equals(object)) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
        int n3 = this.table.length;
        if (this.count++ >= n3 * 3 >>> 2) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = entry = new Entry(n, object, object2, this.table[n2]);
        return null;
    }

    public Object remove(Object object) {
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = null;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key.equals(object)) {
                Object object2 = entry2.value;
                if (entry == null) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.count;
                return object2;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public Object key(int n) {
        if (n < 0 || n >= this.count) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Entry entry = this.table[n3];
            if (entry != null) {
                do {
                    if (n2++ != n) continue;
                    return entry.key;
                } while ((entry = entry.next) != null);
            }
            ++n3;
        }
        return null;
    }

    public Object item(int n) {
        if (n < 0 || n >= this.count) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.table.length) {
            Entry entry = this.table[n3];
            if (entry != null) {
                do {
                    if (n2++ != n) continue;
                    return entry.value;
                } while ((entry = entry.next) != null);
            }
            ++n3;
        }
        return null;
    }

    public void clear() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        public Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }
    }
}

