% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_factor.R
\name{plot_factor}
\alias{plot_factor}
\title{Visualization of factor scores}
\usage{
plot_factor(sim_object = NULL, factor_num = NULL)
}
\arguments{
\item{sim_object}{R object containing data to be plotted}

\item{factor_num}{Factor to be plotted.}
}
\value{
A ggplot object representing the factor scores for the specified factor (or all factors) in \code{sim_object}.
If \code{factor_num = 'all'}, a combined plot of all factors is returned. If a specific \code{factor_num} is provided, the plot for that factor is returned.
The plot can be further customized or displayed using standard \code{ggplot2} functions.
}
\description{
Visualization of factor scores
}
\examples{
# Examples
output_obj <- OmixCraftHD(
  vector_features = c(2000,3000),
  sigmas_vector=c(3,4),
  n_samples=30,
  n_factors=1
)
plot_factor(sim_object = output_obj, factor_num = 1)
plot_factor(sim_object = output_obj, factor_num = 'all')
}
