% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype_functions.R
\name{stringCoverage.control}
\alias{stringCoverage.control}
\title{String coverage coontrol object}
\usage{
stringCoverage.control(motifLength = 4, Type = "AUTOSOMAL",
  simpleReturn = TRUE, includeLUS = FALSE, numberOfThreads = 4L,
  meanFunction = mean, includeAverageBaseQuality = FALSE, trace = FALSE,
  uniquelyAssigned = TRUE)
}
\arguments{
\item{motifLength}{The motif lengths of each marker.}

\item{Type}{The chromosome type of each marker (autosomal, X, or Y).}

\item{simpleReturn}{TRUE/FALSE: Should the returned object be simplified?}

\item{includeLUS}{TRUE/FALSE: Should the LUS of each region be calculated?}

\item{numberOfThreads}{The number of cores used for parallelisation.}

\item{meanFunction}{The function used to average the base qualities.}

\item{includeAverageBaseQuality}{Should the average base quality of the region be included?}

\item{trace}{TRUE/FALSE: Show trace?}

\item{uniquelyAssigned}{TRUE/FALSE: Should regions not uniquely assigned be removed?}
}
\value{
List of parameters used for the 'stringCoverage' function.
}
\description{
String coverage coontrol object
}
\details{
Control function for the 'stringCoverage' function. Sets default values for the parameters.
}
