% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-progression-table.R
\name{plot_progression_table}
\alias{plot_progression_table}
\title{Plotting of the Progression Table}
\usage{
plot_progression_table(
  progression_table = progression_RIR_increment,
  plot = "\%1RM",
  signif_digits = 3,
  adjustment_multiplier = 1,
  ...
)
}
\arguments{
\item{progression_table}{Function for creating progression table. Default is \code{\link{progression_RIR_increment}}}

\item{plot}{Character string. Options include "\%1RM" (default) and "adjustment"}

\item{signif_digits}{Rounding numbers for plotting. Default is 3}

\item{adjustment_multiplier}{Factor to multiply the adjustment. Useful when converting to percentage.
Default is 1}

\item{...}{Forwarder to the \code{\link{generate_progression_table}} function}
}
\value{
\code{ggplot2} object
}
\description{
Functions for creating \code{ggplot2} plot of the Progression Table
}
\examples{
plot_progression_table(progression_RIR_increment, "\%1RM")
plot_progression_table(progression_RIR_increment, "adjustment")

# Create progression pot by using specific reps-max table and klin value
plot_progression_table(
  progression_RIR,
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)
}
