% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_network_gradient.R
\name{visualize_spatial_gradient}
\alias{visualize_spatial_gradient}
\title{Visualize spatial network with expression gradient}
\usage{
visualize_spatial_gradient(
  spatial_data,
  sample,
  gradient_type,
  fixed_type,
  expression_col = "gen2_SPLIz_numeric",
  x_col = "pxl_row_in_fullres",
  y_col = "pxl_col_in_fullres",
  type_col = "Epi_strom",
  fixed_color = "#A9C6D9",
  line_color = "#666666",
  gradient_palette = "C",
  point_size = 1,
  point_alpha = 0.8,
  line_width = 0.3,
  line_alpha = 0.6,
  show_legend = TRUE,
  legend_title = "Expression",
  grid_major_color = "gray90",
  grid_minor_color = "gray95",
  border_color = "black",
  background_color = "white"
)
}
\arguments{
\item{spatial_data}{Spatial coordinates data frame containing cell types and expression values}

\item{sample}{Sample name in the spatial transcriptome data}

\item{gradient_type}{Cell type to show with expression gradient coloring}

\item{fixed_type}{Cell type to show in fixed color (default gray)}

\item{expression_col}{Column name containing expression values (default "gen2_SPLIz_numeric")}

\item{x_col}{Column name for x-coordinates (default "pxl_row_in_fullres")}

\item{y_col}{Column name for y-coordinates (default "pxl_col_in_fullres")}

\item{type_col}{Column name for cell type information (default "Epi_strom")}

\item{fixed_color}{Color for the fixed cell type (default "#A9C6D9" - light gray-blue)}

\item{line_color}{Color for connection lines (default "#666666" - dark gray)}

\item{gradient_palette}{Color palette for expression gradient (default viridis option "C")}

\item{point_size}{Size of points (default 1)}

\item{point_alpha}{Transparency of points (default 0.8)}

\item{line_width}{Width of connection lines (default 0.3)}

\item{line_alpha}{Transparency of connection lines (default 0.6)}

\item{show_legend}{Logical whether to show legend (default TRUE)}

\item{legend_title}{Title for the legend (default "Expression")}

\item{grid_major_color}{Color for major grid lines (default "gray90")}

\item{grid_minor_color}{Color for minor grid lines (default "gray95")}

\item{border_color}{Color for plot border (default "black")}

\item{background_color}{Color for plot background (default "white")}
}
\value{
A ggplot object showing the spatial relationships with expression gradient
}
\description{
Visualize spatial network with expression gradient
}
\examples{
visualize_spatial_gradient(spatial_data = posi,
                           sample="SP8",
                           gradient_type = "Epithelial_cells_A",
                           fixed_type = "Macrophage",
                           expression_col = "gen2_SPLIz_numeric",
                           type_col = "celltype_ABCDepi",
                           legend_title = "Expression",
                           background_color = "white")
}
