% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stb.R
\name{plot.stbVCA}
\alias{plot.stbVCA}
\title{Plot Objects of Class 'stbVCA'.}
\usage{
\method{plot}{stbVCA}(x, orient = 1, pick = FALSE, type = NULL, ...)
}
\arguments{
\item{x}{(object) of class 'STB' as generated by function \code{getSTB}}

\item{orient}{(integer) in 'type=1' plots, 1 = expected vs. observed values, 2 = observed vs. expected values}

\item{pick}{(logical, integer) TRUE = triggers function \code{\link{identify}} for identification
   of points using the mouse. Stop interactive identification by pressing 'Esc' or
   "Right-Mousclick --> Stop". If 'TRUE' and 'type=3', identified points will be added to the residual
plot with STI automatically. If 'pick=1', only in the QQ-plot identification will be toggled, and if
   'pick=2' only in the residual plot identification will be possible.}

\item{type}{(integer) 1 = plot simultaneous tolerance band (STB), 2 = plot simultaneous tolerance interval (STI),
3 = plot STB and STI}

\item{...}{additional arguments changing the visual appearance of the plot, e.g.
'pch', 'pch.out', 'col', 'col.out', 'stb.col', 'stb.main', "'sti.main', 'legend', ...
in fact all elements of 'x'}
}
\value{
(stbVCA) object is invisibly returned, any additional compution results are added
}
\description{
Standard plotting method for objects of Class 'stbVCA'.
}
\details{
This function plots objects of class 'stbVCA' as generated by function \code{\link{stb.VCA}}.
Objects of S3-class 'stbVCA' are list-type objects storing all the information
needed to plot QQ-plots with simultaneous tolerance bounds. Additionally to the information
contained in ordinary 'STB' objects, a copy of the 'VCA' object is stored as well as the
type of random variate and the mode, i.e. the type of transformation applied.

One can specify additional parameters for changing the appearance of the plot(s). Any of the following
parameters can be set to a value different from the default: \cr
\tabular{lcl}{
\code{legend}   \tab ... \tab (logical) TRUE = will add legend to plot(s) (is default) \cr 
\code{pch}      \tab ... \tab plotting symbol for non-outlying points (default=16) \cr 
\code{col}      \tab ... \tab point color for non-outlying points (default="black") \cr 
\code{col.out}  \tab ... \tab point color for outlying points (default="red") \cr 
\code{pch.out}  \tab ... \tab plotting symbold for outlying points (default=16) \cr 
\code{stb.col}  \tab ... \tab color of the STB in the QQ-plot (default="#0000FF40") \cr 
\code{stb.lpos} \tab ... \tab position placement as done in function 'legend', or, character string "title" indicating\cr
                \tab     \tab that legend information should be displayed as (sub-main) title (default="title") \cr 
\code{stb.main} \tab ... \tab character string used as main title in the QQ-plot with STB \cr 
\code{sti.lty}  \tab ... \tab line type for STI-bounds in the residual plot (default=2) \cr 
\code{sti.lwd}  \tab ... \tab line width for STI-bounds (default=1) \cr 
\code{sti.col}  \tab ... \tab line color for STI bounds (default="red") \cr 
\code{sti.ylab} \tab ... \tab character string specifying the Y-axis label in the resiudal plot with STI \cr 
\code{sti.lpos} \tab ... \tab position placement as done in function 'legend' (default="topright") \cr 
\code{sti.main} \tab ... \tab character string used as main title in the residual plot with STI \cr
}
}
\examples{
\dontrun{
library(VCA)
data(dataEP05A2_1)
fit <- anovaVCA(y~day/run, dataEP05A2_1)
fit

# use studentized conditional residuals
stb.obj1 <- stb.VCA(fit, term="cond", mode="student", N=1000)

# plot it again
plot(stb.obj1)

# use random effects "day" and apply standardization
stb.obj2 <- stb.VCA(fit, term="day", mode="stand", N=1000)

# plot it again
plot(stb.obj2)

# initially, request QQ-plot with STB
stb.obj3 <- stb.VCA(fit, term="day", mode="stand", N=1000, type=1)

# now request plotting of the residual plot as well
# catch computation result which are invisibly returned
stb.obj4 <- plot(stb.obj3, type=3)

# individualize the appearance of the plot
plot(stb.obj4, sti.lpos="top", col="darkblue", out.pch=17, out.col="green") 
}
}
\seealso{
\link{stb.VCA}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
