% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMeans.R
\name{constrained_kmeans}
\alias{constrained_kmeans}
\title{General Interface Constrained KMeans}
\usage{
constrained_kmeans(max_iter = 10, method = "euclidean")
}
\arguments{
\item{max_iter}{maximum iterations in KMeans. Default is 10}

\item{method}{distance method in KMeans: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski"}
}
\description{
The initialization is the same as seeded kmeans,
the difference is that in the following steps the allocation of the clusters in
the labelled data does not change
}
\examples{
library(tidyverse)
library(caret)
library(SSLR)
library(tidymodels)

data <- iris

set.seed(1)
#\% LABELED
cls <- which(colnames(iris) == "Species")

labeled.index <- createDataPartition(data$Species, p = .2, list = FALSE)
data[-labeled.index,cls] <- NA


m <- constrained_kmeans() \%>\% fit(Species ~ ., data)

#Get labels (assing clusters), type = "raw" return factor
labels <- m \%>\% cluster_labels()

print(labels)


#Get centers
centers <- m \%>\% get_centers()

print(centers)

}
\references{
Sugato Basu, Arindam Banerjee, Raymond Mooney\cr
\emph{Semi-supervised clustering by seeding}\cr
July 2002
In Proceedings of 19th International Conference on Machine Learning
}
