% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_methods.R
\name{find_redundant_contigs}
\alias{find_redundant_contigs}
\title{Find redundant contigs within a bin}
\usage{
find_redundant_contigs(SQM, bin, minimum_overlap_for_removal = 1)
}
\arguments{
\item{SQM}{A SQM object.}

\item{bin}{character. Name of the bin to be created.}

\item{minimum_overlap_for_removal}{numeric. Fraction of marker genes in the contigs present in another contig needed to suggest it for removal. If set to \code{1} (default), contigs will only suggested for removal if their markers fully overlap with those in another contig (and thus completeness will not change after removing them). Smaller values will result in more contigs being suggested for removal, which will further reduce contamination at the expense of some completeness.}
}
\value{
A character vector with the contigs deemed to be redundant. A heatmap showing how marker genes overlap over different contigs will also be produced.
}
\description{
Find contigs with overlapping marker genes in a given bin, and suggest contigs to be removed in order to reduce contamination without affecting completeness. Note that this can give a quick idea of the contigs that are sources of contamination within a bin, but is not a replacement for proper bin refininement with other tools such as anvi\'o.
}
\examples{
data(Hadza)
bin_name = "Hadza2merged.concoct.28.fa.contigs"
# Get redundant contigs that could be removed from our bin
candidates_for_removal = find_redundant_contigs(Hadza, bin_name)
# We can now remove them from the bin
Hadza.new.1 = remove_contigs_from_bin(Hadza, bin_name, candidates_for_removal)
# Or we can create a new bin out of them
#  which will also remove them from the original bin
Hadza.new.2 = create_bin(Hadza, "new_bin_name", candidates_for_removal)
}
\seealso{
\code{\link{create_bin}}, \code{\link{remove_contigs_from_bin}}
}
