% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot a heatmap using ggplot2}
\usage{
plotHeatmap(
  data,
  label_x = "Samples",
  label_y = "Features",
  label_fill = "Abundance",
  gradient_col = c("ghostwhite", "dodgerblue4"),
  base_size = 11,
  metadata_groups = NULL
)
}
\arguments{
\item{data}{numeric matrix or data frame.}

\item{label_x}{character Label for the x axis (default \code{"Samples"}).}

\item{label_y}{character Label for the y axis (default \code{"Features"}).}

\item{label_fill}{character Label for color scale (default \code{"Abundance"}).}

\item{gradient_col}{A vector of two colors representing the low and high ends of the color gradient (default \code{c("ghostwhite", "dodgerblue4")}).}

\item{base_size}{numeric. Base font size (default \code{11}).}

\item{metadata_groups}{list. Split the plot into groups defined by the user: list('G1' = c('sample1', sample2'), 'G2' = c('sample3', 'sample4')) default \code{NULL}).}
}
\value{
A ggplot2 plot object.
}
\description{
Plot a ggplot2 heatmap from a matrix or data frame. The data should be in tabular format (e.g. features in rows and samples in columns).
}
\examples{
data(Hadza)
topPFAM = mostAbundant(Hadza$functions$PFAM$tpm)
topPFAM = topPFAM[rownames(topPFAM) != "Unclassified",] # Take out the Unclassified ORFs.
plotHeatmap(topPFAM, label_x = "Samples", label_y = "PFAMs", label_fill = "TPM")
}
\seealso{
\code{\link{plotFunctions}} for plotting the top functional categories of a SQM object; \code{\link{plotBars}} for plotting a barplot with arbitrary data; \code{\link{mostAbundant}} for selecting the most abundant rows in a dataframe or matrix.
}
