% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_refimg.R
\name{refImageContinuous}
\alias{refImageContinuous}
\title{\code{refImageContinuous} returns the reference image, calculated using the
\code{refMethod}.
This images represents the basic measure for the filters in SPUTNIK.}
\usage{
refImageContinuous(
  msiData,
  method = "sum",
  mzQueryRef = numeric(),
  mzTolerance = Inf,
  useFullMZRef = TRUE,
  doSmooth = FALSE,
  smoothSigma = 2,
  alignTo = "detected",
  invertAligned = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{msiData}{\link[SPUTNIK]{msiDataset} object..}

\item{method}{string (default = "sum"). Method used to calculate the
reference image. Valid values are:
\itemize{
  \item "sum": peak intensities sum
  \item "mean": average peak intensities (without zeros)
  \item "median": median peak intensities (without zeros)
  \item "pca": first principal component scores.
}}

\item{mzQueryRef}{numeric. Values of m/z used to calculate the reference image.
2 values are interpreted as interval, multiple or single values are searched
in the m/z vector. It overrides the param \code{useFullMZRef}.}

\item{mzTolerance}{numeric (default = Inf). Tolerance in PPM to match the
\code{mzQueryRef} values in the m/z vector.}

\item{useFullMZRef}{logical (default = TRUE). Whether all the peaks should be
used to calculate the reference image.}

\item{doSmooth}{logical (default = FALSE). Whether the reference image
should be smoothed before binarizing. Only valid for \code{roiMethod = "otsu"}.}

\item{smoothSigma}{numeric (default = 2). Standard deviation of Gaussian
kernel.}

\item{alignTo}{string (default = "detected"). Image used as reference for
aligning the estimated reference and ROI image. Valid values are:
\itemize{
 \item "detected": number of detected peaks
 \item "tic": total-ion-count image
}}

\item{invertAligned}{logical (default = FALSE). Whether the reference image
colors should be positively or negatively correlated with the sample reference
(defined by the argument \code{alignTo}). In case the sample reference is **higher**
outside of the sample region, set it to TRUE.}

\item{verbose}{logical (default = TRUE). Additional output text.}
}
\description{
\code{refImageContinuous} returns the reference image, calculated using the
\code{refMethod}.
This images represents the basic measure for the filters in SPUTNIK.
}
\details{
Function to extract the continuous reference image from a 
\code{\link{msi.dataset-class}} object.
Multiple methods can be used to extract the reference image, which afterwards 
can be used as argument for the \code{\link{globalPeaksFilter}} filter.
}
\examples{
## Load package
library("SPUTNIK")

## Mass spectrometry intensity matrix
X <- matrix(rnorm(200), 20, 40)
X[X < 0] <- 0

## Print original dimensions
print(dim(X))

## m/z vector
mzVector <- seq(600, 900, by = (900 - 600) / 39)

## Read the image size
imSize <- c(5, 4)

## Construct the ms.dataset object
msiX <- msiDataset(X, mzVector, imSize[1], imSize[2])

## Calculate the reference and ROI images from the ms.dataset-class object msiX.
## The reference is calculated as the first principal component scores scaled
## in [0, 1]; the binary ROI is calculated applying k-means on the entire dataset.
## Use only m/z values in the range of [700, 900]. The interval extremal values
## are matched within a tolerance of 50 ppm.

refImg <- refImageContinuous(msiX, method = "sum")
roiImg <- refImageBinaryOtsu(refImg)

## Plot the reference and region of interest ROI
## plot(ref.roi$Reference)
## plot(ref.roi$ROI)
}
\seealso{
msiDataset
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
