% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.SPQR.R
\name{coef.SPQR}
\alias{coef.SPQR}
\title{coef method for class \code{SPQR}}
\usage{
\method{coef}{SPQR}(object, X, ...)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{X}{The covariate vector/matrix for which the coefficient is calculated.}

\item{...}{Other arguments.}
}
\value{
A \code{NROW(X)} by K matrix containing values of the estimated coefficient, where K is the number of basis functions.
}
\description{
Computes the estimated spline coefficients of a \code{SPQR} class object
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)
coef(fit, X = 0)
}
}
