% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{plotSIRModel}
\alias{plotSIRModel}
\title{plotSIRModel}
\usage{
plotSIRModel(x, days, N, n = 3, logy = FALSE)
}
\arguments{
\item{x}{vector of four parameters. Used for parametrizing the MarkovChain model and calulation of fatalities.
\describe{
    \item{\code{p}}{num  [0;1] proportion of confirmed cases}
    \item{\code{beta}}{num  A numeric vector with the transmission rate from susceptible to infected where each node can have
    a different beta value. The vector must have length 1 or nrow(u0).
    If the vector has length 1, but the model contains more nodes,
    the beta value is repeated in all nodes.}
    \item{\code{gamma}}{num  A numeric vector with the recovery rate from infected to recovered where each node can have
    a different gamma value. The vector must have length 1 or nrow(u0).
    If the vector has length 1, but the model contains more nodes, the beta value is repeated in all nodes.}
    \item{\code{CFR}}{num  [0;1] proportion of fatalities}
    }}

\item{days}{number of simulation steps, usually days (int).
It will be used to generate (internally) a vector (length >= 1)
of increasing time points where the state of each node is to be returned.}

\item{N}{population size}

\item{n}{number of nodes to be evaluated in the \code{\link[SimInf]{SIR}} model}

\item{logy}{logical Plot logarithmic y axis. Default: FALSE}
}
\value{
plot
}
\description{
Plot of continuous time Markov chains (MarkovChain)
 \code{\link[SimInf]{SIR}} models.
}
\details{
SIR considers three compartments: S (susceptible), I (infected), and R (recovered).
The timespan is calculated as \code{tspan = 1:days}.
}
\examples{
\donttest{
require("SimInf")
# Result from \code{\link{parseTunedRegionModel}}, e.g., deModels:
# parameters: x = c(deModels$p, deModels$beta, deModels$gamma, deModels$CFR)
x = c(1e-05, 0.216764668858674, 0.204440265426977, 0.100982384347174)
plotSIRModel(x, days=1000, N = 83783945, n=10, logy=TRUE)
}
}
