% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{funPowellBs}
\alias{funPowellBs}
\title{funPowellBs (No. 9, More No. 3)}
\usage{
funPowellBs(x)
}
\arguments{
\item{x}{matrix of points to evaluate with the function.
Rows for points and columns for dimension.}
}
\value{
1-column matrix with resulting function values
}
\description{
2-dim Powell Badly Scaled Test Function
}
\examples{
x1 <- matrix(c(-1,1),1,)
funPowellBs(x1)

# Running SPOT with 20 function evaluations with default configurations
res <- spot(,fun=funPowellBs,c(-10,-10),c(10,10),control=list(funEvals=20))
plotModel(res$model, points = rbind(c(res$xbest[1], res$xbest[2]),c(1.098e-5,9.106)))

}
\references{
More, J. J., Garbow, B. S., and  Hillstrom, K. E. (1981).
Testing unconstrained optimization software.
\emph{ACM Transactions on Mathematical Software (TOMS)}, \emph{7}(1), 17-41.
\doi{10.1145/355934.355936}

Powell, M.J.D. (1970).
A hybrid method for nonlinear equations.
In Numerical methods for Nonlinear Algebraic Equations,
P. Rabinowitz (Ed),
\emph{Gordon & Breach, New York.}, \emph{3}(3), 87-114.
}
