% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{triangular}
\alias{triangular}
\alias{ptri}
\alias{dtri}
\alias{qtri}
\alias{rtri}
\title{The Triangular Distribution}
\usage{
ptri(q, min, max, mode)

dtri(x, min, max, mode)

qtri(p, min, max, mode)

rtri(n, min, max, mode)
}
\arguments{
\item{min}{vector of minimum values.}

\item{max}{vector of maximum values.}

\item{mode}{vector of modes.}

\item{x, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}
}
\value{
\code{dtri} gives the density, \code{ptri} gives the distribution function,
\code{qtri} gives the quantile function, and \code{rtri} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the triangular distribution with parameters \code{min}, \code{max} and \code{mode}.
}
\details{
The triangular distribution with parameters \code{min}\eqn{= a}, \code{max}
\eqn{= b}, \code{mode}\eqn{= c} has density:
\tabular{lll}{
\eqn{f(x) =}
\tab \eqn{\frac{2(x-a)}{(b-a)(c-a)}} \tab for \eqn{a < x \le c} \cr
\tab \eqn{\frac{2(b-x)}{(b-a)(b-c)}} \tab for \eqn{c < x \le b} \cr
\tab \eqn{0} \tab otherwise
} and distribution function:
\tabular{lll}{
\eqn{F(x) =}
\tab \eqn{0} \tab for \eqn{x \le a} \cr
\tab \eqn{\frac{(x-a)^2}{(b-a)(c-a)}} \tab for \eqn{a < x \le c} \cr
\tab \eqn{1 - \frac{(b-x)^2}{(b-a)(b-c)}} \tab for \eqn{c < x \le b} \cr
\tab \eqn{1} \tab for \eqn{x > b}
}
for \eqn{a \le c \le b}.
}
\examples{
ptri(c(0, 1/2, 1), min = 0, max = 1, mode = 1/2)
dtri(c(0, 1/2, 1), min = 0, max = 1, mode = 1/2)
plot(function(x) dtri(x, min = 0, max = 1, mode = 1/2), 0, 1)
}
