% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.plot.R
\name{i.plot}
\alias{i.plot}
\title{Plot a Selected Time Series Using Quantile as the Background}
\usage{
i.plot(x, idx = 1, prob = c(0.25, 0.5, 0.75), xtime = NULL)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{idx}{Selected time series.}

\item{prob}{Probability, the quantile series of which is to be computed.
Default values are 0.25, 0.5, 0.75.}

\item{xtime}{A vector with the values for the x labels. Default values are 1, 2, 3, ...}
}
\value{
standardized - Matrix containing the standardized time series.
}
\description{
Plot a selected time series using quantile as the background.
}
\examples{
data(TaiwanAirBox032017)
output <- i.plot(TaiwanAirBox032017[,1:3])

}
