% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{createCrossPlan}
\alias{createCrossPlan}
\title{Create a plan for crossing virgin queens}
\usage{
createCrossPlan(
  x,
  drones = NULL,
  droneColonies = NULL,
  nDrones = NULL,
  spatial = FALSE,
  radius,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}} or \code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}},
the object with the virgin queens that need to be crossed. When \code{spatial = TRUE},
the argument needs to be a \code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}
with the location set}

\item{drones}{\code{\link[AlphaSimR]{Pop-class}}, a population of drones (resembling a drone
congregation area) available for mating. When \code{spatial = TRUE}, the user can not
provide drones, but needs to provide drone producing colonies instead
(see argument \code{droneColonies})}

\item{droneColonies}{\code{\link[SIMplyBee]{MultiColony-class}}, drone producing colonies
available for mating. When \code{spatial = TRUE},
the object needs to have the location set}

\item{nDrones, }{integer or function, number of drones to sample for each crossing. You need to provide
this to provide this argument even when sampling drone producing colonies (otherwise, the default value
will be used)}

\item{spatial}{logical, whether the drone producing colonies should be sampled according
to their distance from the virgin colony (that is, in a radius)}

\item{radius}{numeric, the radius from the virgin colony in which to sample mating partners,
only needed when \code{spatial = TRUE}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}

\item{...}{other arguments for \code{nDrones}, when \code{nDrones} is a function}
}
\value{
named list with names being virgin queens/colonies IDs with each
  list element holding the IDs of selected drones or drone producing colonies
}
\description{
Level 0 function that creates a plan for crossing virgin queens or
  virgin colonies by sampling drones or drone producing colonies to mate with a the
  virgin queens/colonies either at random (\code{spatial = FALSE})
  or according to the distance between colonies (\code{spatial = TRUE}).
}
\examples{
founderGenomes <- quickHaplo(nInd = 1000, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

# Create three virgin MultiColony objects with locations
virginColonies1 <- createMultiColony(basePop[1:30])
virginColonies1 <- setLocation(virginColonies1,
                               location = Map(c, runif(30, 0, 2*pi),
                                                 runif(30, 0, 2*pi)))
virginColonies2 <- createMultiColony(basePop[31:60])
virginColonies2 <- setLocation(virginColonies2,
                               location = Map(c, runif(30, 0, 2*pi),
                                                 runif(30, 0, 2*pi)))
virginColonies3 <- createMultiColony(basePop[61:90])
virginColonies3 <- setLocation(virginColonies3,
                               location = Map(c, runif(30, 0, 2*pi),
                                                 runif(30, 0, 2*pi)))

# Create drone colonies
droneColonies <- createMultiColony(basePop[121:200])
droneColonies <- setLocation(droneColonies,
                             location = Map(c, runif(80, 0, 2*pi),
                                               runif(80, 0, 2*pi)))

# Create some drones to mate initial drone colonies with
DCA <- createDrones(basePop[201:300], nInd = 20)
# Cross initial virgin drone colonies to the DCA with a random cross plan
randomCrossPlan <- createCrossPlan(x = droneColonies,
                                   drones = DCA,
                                   nDrones = nFathersPoisson,
                                   spatial = FALSE)
droneColonies <- cross(droneColonies,
                       drones = DCA,
                       nDrones = nFathersPoisson,
                       crossPlan = randomCrossPlan)

# Plot the colonies in space
virginLocations <- as.data.frame(getLocation(c(virginColonies1, virginColonies2, virginColonies3),
                                             collapse= TRUE))
virginLocations$Type <- "Virgin"
droneLocations <- as.data.frame(getLocation(droneColonies, collapse= TRUE))
droneLocations$Type <- "Drone"
locations <- rbind(virginLocations, droneLocations)

plot(x = locations$V1, y = locations$V2,
     col = c("red", "blue")[as.numeric(as.factor(locations$Type))])

# Cross according to a spatial cross plan according to the colonies' locations
crossPlanSpatial <- createCrossPlan(x = virginColonies1,
                                   droneColonies = droneColonies,
                                   nDrones = nFathersPoisson,
                                   spatial = TRUE,
                                   radius = 1.5)

# Plot the crossing for the first colony in the crossPlan
virginLocations1 <- as.data.frame(getLocation(virginColonies1, collapse= TRUE))
virginLocations1$Type <- "Virgin"
droneLocations <- as.data.frame(getLocation(droneColonies, collapse= TRUE))
droneLocations$Type <- "Drone"
locations1 <- rbind(virginLocations1, droneLocations)

# Blue marks the target virgin colony and blue marks the drone colonies in the chosen radius
plot(x = locations1$V1, y = locations1$V2, pch = c(1, 2)[as.numeric(as.factor(locations1$Type))],
  col = ifelse(rownames(locations1) \%in\% crossPlanSpatial[[1]],
                             "red",
                             ifelse(rownames(locations1) == names(crossPlanSpatial)[[1]],
                             "blue", "black")))

colonies1 <- cross(x = virginColonies1,
                   crossPlan = crossPlanSpatial,
                   droneColonies = droneColonies,
                   nDrones = nFathersPoisson)
nFathers(colonies1)

# Cross according to a cross plan that is created internally within the cross function
# The cross plan is created at random, regardless the location of the colonies
colonies2 <- cross(x = virginColonies2,
                   droneColonies = droneColonies,
                   nDrones = nFathersPoisson,
                   crossPlan = "create")

# Mate spatially with cross plan created internally by the cross function
colonies3 <- cross(x = virginColonies3,
                   droneColonies = droneColonies,
                   crossPlan = "create",
                   checkCross = "warning",
                   spatial = TRUE,
                   radius = 1)

}
