% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covk.2001Schott.R
\name{covk.2001Schott}
\alias{covk.2001Schott}
\title{Test for Homogeneity of Covariances by Schott (2001)}
\usage{
covk.2001Schott(dlist)
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample matrix of same dimension.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \Sigma_1 = \cdots \Sigma_k\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Schott (2001) using Wald statistics. In the original paper, it provides 4 
different test statistics for general elliptical distribution cases. However, we only deliver 
the first one with an assumption of multivariate normal population.
}
\examples{
## CRAN-purpose small example
tinylist = list()
for (i in 1:3){ # consider 3-sample case
  tinylist[[i]] = matrix(rnorm(10*3),ncol=3)
}
covk.2001Schott(tinylist) # run the test

\dontrun{
## test when k=5 samples with (n,p) = (100,20)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = matrix(rnorm(100*20),ncol=20)
  }
  
  counter[i] = ifelse(covk.2001Schott(mylist)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'covk.2001Schott'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{schott_tests_2001}{SHT}
}
\concept{covariance}
