% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{get_worms_taxonomy_tree}
\alias{get_worms_taxonomy_tree}
\title{Retrieve hierarchical taxonomy data from WoRMS}
\usage{
get_worms_taxonomy_tree(
  aphia_ids,
  add_descendants = FALSE,
  add_descendants_rank = "Species",
  add_synonyms = FALSE,
  add_hierarchy = FALSE,
  add_rank_to_hierarchy = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{aphia_ids}{Numeric vector of AphiaIDs to retrieve taxonomy for. Must
not be missing or all NA.}

\item{add_descendants}{Logical (default FALSE). If TRUE, retrieves all
child taxa for each taxon at the rank specified by \code{add_descendants_rank}.}

\item{add_descendants_rank}{Character (default \code{"Species"}). The taxonomic
rank of descendants to retrieve. For example, if set to \code{"Species"}, the
function will collect all species belonging to each genus present in the
initial dataset.}

\item{add_synonyms}{Logical (default FALSE). If TRUE, retrieves synonym
records for all retrieved taxa and appends them to the dataset.}

\item{add_hierarchy}{Logical (default FALSE). If TRUE, adds a \code{hierarchy}
column that contains the concatenated hierarchy of each taxon (e.g. Kingdom - Phylum - Class).}

\item{add_rank_to_hierarchy}{Logical (default FALSE). If TRUE, the hierarchy
string prepends rank names (e.g., \verb{[Kingdom] Animalia - [Phylum] Chordata})
to each taxon name in the \code{hierarchy} column. Only used if \code{add_hierarchy = TRUE}.}

\item{verbose}{Logical (default TRUE). If TRUE, prints progress messages
and progress bars during data retrieval.}
}
\value{
A \code{tibble} containing detailed WoRMS records for all requested
AphiaIDs, including optional descendants and synonyms. Typical columns
include:
\describe{
\item{AphiaID}{The AphiaID of the taxon.}
\item{parentNameUsageID}{The AphiaID of the parent taxon.}
\item{scientificname}{Scientific name of the taxon.}
\item{rank}{Taxonomic rank (e.g., Kingdom, Phylum, Genus, Species).}
\item{status}{Taxonomic status (e.g., accepted, unaccepted).}
\item{valid_AphiaID}{AphiaID of the accepted taxon, if the record is a synonym.}
\item{species}{Added only if a \code{Species} rank exists in the retrieved
data and if \code{add_hierarchy = TRUE}; otherwise not present.}
\item{parentName}{Added only if a \code{parentName} rank exists in the retrieved
data and if \code{add_hierarchy = TRUE}; otherwise not present.}
\item{hierarchy}{Added only if \code{add_hierarchy = TRUE} and hierarchy
data are available. Contains a concatenated string of the taxonomic
path.}
\item{...}{Additional columns returned by WoRMS, including authorship
and source information.}
}
}
\description{
Retrieves the hierarchical taxonomy for one or more AphiaIDs from the
World Register of Marine Species (WoRMS). Optionally, the function can
include all descendants of taxa at a specified rank and/or synonyms for
all retrieved taxa.
}
\details{
The function performs the following steps:
\enumerate{
\item Validates input AphiaIDs and removes NA values.
\item Retrieves the hierarchical classification for each AphiaID using
\code{worrms::wm_classification()}.
\item Optionally retrieves all descendants at the rank specified by
\code{add_descendants_rank} if \code{add_descendants = TRUE}.
\item Optionally retrieves synonyms for all retrieved taxa if
\code{add_synonyms = TRUE}.
\item Optionally adds a \code{hierarchy} column if \code{add_hierarchy = TRUE}.
\item Returns a combined, distinct dataset of all records.
}
}
\examples{
\donttest{
# Retrieve hierarchy for a single AphiaID
get_worms_taxonomy_tree(aphia_ids = 109604, verbose = FALSE)

# Retrieve hierarchy including species-level descendants
get_worms_taxonomy_tree(
  aphia_ids = c(109604, 376667),
  add_descendants = TRUE,
  verbose = FALSE
)

# Retrieve hierarchy including hierarchy column
get_worms_taxonomy_tree(
  aphia_ids = c(109604, 376667),
  add_hierarchy = TRUE,
  verbose = FALSE
)
}

}
\seealso{
\code{\link{add_worms_taxonomy}}, \code{\link{construct_dyntaxa_table}}

\code{\link[worrms]{wm_classification}}, \code{\link[worrms]{wm_children}}, \code{\link[worrms]{wm_synonyms}}

\url{https://marinespecies.org/} for the WoRMS website.
}
