% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_api_functions.R
\name{get_shark_datasets}
\alias{get_shark_datasets}
\title{Download SHARK dataset zip archives}
\usage{
get_shark_datasets(
  dataset_name,
  save_dir = NULL,
  prod = TRUE,
  utv = FALSE,
  unzip_file = FALSE,
  return_df = FALSE,
  encoding = "latin_1",
  guess_encoding = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{dataset_name}{Character vector with one or more dataset
names (or partial names). Each entry will be matched against
available SHARK dataset identifiers (e.g.,
\code{"SHARK_Phytoplankton_2023_SMHI_BVVF"} for a specific dataset,
or \code{"SHARK_Phytoplankton"} for all Phytoplankton datasets).}

\item{save_dir}{Directory where zip files (and optionally their
extracted contents) should be stored. Defaults to \code{NULL}. If
\code{NULL} or \code{""}, a temporary directory is used.}

\item{prod}{Logical, whether to download from the production
(\code{TRUE}, default) or test (\code{FALSE}) SHARK server. Ignored if \code{utv} is \code{TRUE}.}

\item{utv}{Logical. Select UTV server when \code{TRUE}.}

\item{unzip_file}{Logical, whether to extract downloaded zip
archives (\code{TRUE}) or only save them (\code{FALSE}, default).}

\item{return_df}{Logical, whether to return a combined data frame
with the contents of all downloaded datasets (\code{TRUE}) instead
of a list of file paths (\code{FALSE}, default).}

\item{encoding}{Character. File encoding of \code{shark_data.txt}. Options: \code{"cp1252"}, \code{"utf_8"}, \code{"utf_16"}, \code{"latin_1"}.
Default is \code{"latin_1"}. If \code{guess_encoding = TRUE}, detected encoding overrides this value.
Ignored if \code{return_df} is \code{FALSE}.}

\item{guess_encoding}{Logical. If \code{TRUE} (default), automatically detect file encoding.
If \code{FALSE}, the function uses only the user-specified encoding.
Ignored if \code{return_df} is \code{FALSE}.}

\item{verbose}{Logical, whether to show download and extraction
progress messages. Default is \code{TRUE}.}
}
\value{
If \code{return_df = FALSE}, a named list of character vectors.
Each element corresponds to one matched dataset and contains either
the path to the downloaded zip file (if \code{unzip_file = FALSE}) or
the path to the extraction directory (if \code{unzip_file = TRUE}).
If \code{return_df = TRUE}, a single combined data frame with all
dataset contents, including a \code{source} column indicating the dataset.
}
\description{
Downloads one or more datasets (zip-archives) from the SHARK database
(Swedish national marine environmental data archive) and
optionally unzips them. The function matches provided dataset
names against all available SHARK datasets.
}
\examples{
\donttest{
# Get a specific dataset
get_shark_datasets("SHARK_Phytoplankton_2023_SMHI_BVVF", verbose = FALSE)

# Get all Zooplankton datasets from 2022 and unzip them
get_shark_datasets(
  dataset_name = "Zooplankton_2022",
  unzip_file = TRUE,
  verbose = FALSE
)

# Get all Chlorophyll datasets and return as a combined data frame
combined_df <- get_shark_datasets(
  dataset_name = "Chlorophyll",
  return_df = TRUE,
  verbose = FALSE
)
head(combined_df)
}

}
\seealso{
\url{https://shark.smhi.se/en} for SHARK database.

\code{\link[=get_shark_options]{get_shark_options()}} for listing available datasets.

\code{\link[=get_shark_data]{get_shark_data()}} for downloading tabular data.
}
