% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggPathways.R
\docType{data}
\name{kegg.pathways}
\alias{kegg.pathways}
\title{KEGG pathways}
\format{
"kegg.pathways" is a list of 225 igraph objects corresponding to the
KEGG pathways.
}
\source{
\url{https://www.genome.jp/kegg/}
}
\usage{
kegg.pathways
}
\description{
KEGG pathways extracted using the \code{ROntoTools}
R package (update: November, 2021).
}
\examples{

\donttest{
library(igraph)

# KEGG pathways
names(kegg.pathways)

i<-which(names(kegg.pathways)=="Type II diabetes mellitus");i
ig<- kegg.pathways[[i]]
summary(ig)
V(ig)$name
E(ig)$weight

gplot(ig, l="fdp", psize=50, main=names(kegg.pathways[i]))

}

}
\references{
Kanehisa M, Goto S (1999). KEGG: kyoto encyclopedia of genes and genomes. 
Nucleic Acid Research 28(1): 27-30. 
<https://doi.org/10.1093/nar/27.1.29>

Calin Voichita, Sahar Ansari and Sorin Draghici (2021).
ROntoTools: R Onto-Tools suite. R package version 2.20.0.
}
