% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SharedBMat.R
\name{SharedBMat}
\alias{SharedBMat}
\title{Shared boundary matrix}
\usage{
SharedBMat(sf_pol, rn = FALSE)
}
\arguments{
\item{sf_pol}{spatial polygons, spatial lines object or spatial data frame}

\item{rn}{logical, default FALSE. If TRUE, the spatial weights matrix is row-normalized}
}
\value{
\item{W}{spatial weights matrix (length of shared boundary between spatial units)}
}
\description{
This function calculates the shared boundary matrix
}
\examples{
library("sf")
\donttest{
ger   <- st_read(system.file(dsn = "shape/GermanyNUTS3.shp", package = "SDPDmod"))
bav <- ger[which(substr(ger$NUTS_CODE,1,3)=="DE2"),] ## Bavaria districts
W     <- SharedBMat(bav)}

}
\author{
Rozeta Simonovska
}
