% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPred.R
\name{plotPred}
\alias{plotPred}
\title{Plot Prediction}
\usage{
plotPred(map, lt = "", colorramp = NULL, hr = FALSE)
}
\arguments{
\item{map}{\link[terra]{rast} object with the prediction.}

\item{lt}{character. Legend title.}

\item{colorramp}{vector. A custom colour ramp given as a vector of colours
(see example), default is \code{NULL} and uses a blue/red colour ramp.}

\item{hr}{logical. If \code{TRUE} produces an output with high resolution.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Plot Prediction output.
}
\examples{
\donttest{
map <- terra::rast(matrix(runif(400, 0, 1),
                          nrow = 20,
                          ncol= 20))

plotPred(map,
         lt = "Habitat suitability \ncloglog")

# Custom colors
plotPred(map,
         lt = "Habitat suitability",
         colorramp = c("#2c7bb6", "#ffffbf", "#d7191c"))
}
}
\seealso{
\link{plotPA}.
}
\author{
Sergio Vignali
}
