% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSWD.R
\name{mergeSWD}
\alias{mergeSWD}
\title{Merge SWD Objects}
\usage{
mergeSWD(swd1, swd2, only_presence = FALSE)
}
\arguments{
\item{swd1}{\linkS4class{SWD} object.}

\item{swd2}{\linkS4class{SWD} object.}

\item{only_presence}{logical, if \code{TRUE} only for the presence locations are
merged and the absence/background locations are taken only from the \code{swd1}
object, default is \code{FALSE}.}
}
\value{
The merged \linkS4class{SWD} object.
}
\description{
Merge two \linkS4class{SWD} objects.
}
\details{
\itemize{
\item In case the two \linkS4class{SWD} objects have different columns, only the
common columns are used in the merged object.
\item The \linkS4class{SWD} object is created in a way that the presence
locations are always before than the absence/background locations.
}
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split only presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Merge the training and the testing datasets together
merged <- mergeSWD(train, test, only_presence = TRUE)

# Split presence and absence locations in training (80\%) and testing (20\%)
datasets
datasets <- trainValTest(data, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Merge the training and the testing datasets together
merged <- mergeSWD(train, test)
}
\author{
Sergio Vignali
}
