% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tables.R
\name{get_tables}
\alias{get_tables}
\title{List the available tables on the connection}
\usage{
get_tables(conn, pattern = NULL, show_temporary = TRUE)
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{pattern}{(\code{character(1)})\cr
Regex pattern with which to subset the returned tables.}

\item{show_temporary}{(\code{logical(1)})\cr
Should temporary tables be listed?}
}
\value{
A data.frame containing table names including schema (and catalog when available) in the database.
}
\description{
List the available tables on the connection
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- get_connection()

  dplyr::copy_to(conn, mtcars, name = "my_test_table_1", temporary = FALSE)
  dplyr::copy_to(conn, mtcars, name = "my_test_table_2")

  get_tables(conn, pattern = "my_[th]est")
  get_tables(conn, pattern = "my_[th]est", show_temporary = FALSE)

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
