% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC.MEB.R
\name{SC.MEB}
\alias{SC.MEB}
\title{SC.MEB.}
\usage{
SC.MEB(
  sce,
  d = 15,
  K = 2:9,
  bet = seq(0, 5, 0.2),
  platform = "Visium",
  maxIter_ICM = 10,
  maxIter = 50
)
}
\arguments{
\item{sce}{is a SingleCellExperiment object containing PCA and position informatin.}

\item{d}{is a integer specifying the dimension of PCA. The default is 15.}

\item{K}{is an integer vector specifying the numbers of mixture components (clusters) for which the BIC is to be calculated. The default is K = 2:9.}

\item{bet}{is a numeric vector specifying the smoothness of Random Markov Field. The default is seq(0,5,0.2).}

\item{platform}{is the name of spatial transcriptomic platform. Specify 'Visium' for hex lattice geometry or 'ST' for square lattice geometry. Specifying this parameter is optional as this information is included in their metadata.}

\item{maxIter_ICM}{is the maximum iteration of ICM algorithm. The default is 10.}

\item{maxIter}{is the maximum iteration of EM algorithm. The default is 50.}
}
\value{
a list, We briefly explain the output of the SC.MEB. 

The item 'best_K' is the optimal K we choose according to BIC rule. 

The item 'best_beta' is also the optimal beta we choose according to BIC rule. 

The item 'best_cluster_label' is the optimal clustering result corresponding to optimal K and optimal beta. 

The item 'best_BIC' is the optimal BIC corresponding to optimal K and optimal beta. 

The item 'best_ell' is the optimal opposite log-likelihood corresponding to optimal K and optimal beta. 

The item 'best_mu' is the optimal mean for each component corresponding to optimal K and optimal beta. 

The item 'best_sigma' is the optimal variance for each component corresponding to optimal K nd optimal beta. 

The item 'best_gam' is the optimal posterior probability matrix corresponding to optimal K and optimal beta.
 
The item 'cluster_label' is 3-dimensional n-by-b-by-q matrix, storing all clustering results for each K and beta. n is the number of cells, b is the length of vector 'bet', q is the length of vector 'K'. 

The item 'BIC' contains all BIC value for each K and beta. 

The item 'ell' is the opposite log-likelihood for each beta and K. 

The item 'mu' is the mean of each component for each beta and K.

The item 'sigma' is the variance of each component for each beta and K.
}
\description{
SC.MEB implements the model SC-MEB, spatial clustering with hidden Markov random field using empirical Bayes.
}
\details{
SC.MEB implements the model SC-MEB, spatial clustering with hidden Markov random field using empirical Bayes.
}
\examples{
## read the simulated data 
data(sce)
d = 5
K = 3
bet = 1
platform = "ST"
maxIter_ICM = 10
maxIter = 50
## run the SC.MEB function
out = SC.MEB(sce, d = d, K = K, bet=bet, platform = platform)
}
\references{
Yang Y, Shi X, Zhou Q, et al. SC-MEB: spatial clustering with hidden Markov random field using empirical Bayes[J]. bioRxiv, 2021.
}
