% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwclust.R
\name{rwclust}
\alias{rwclust}
\title{Sharpen the edge weights of a weighted graph.}
\usage{
rwclust(x, similarity = "hk", iter, k)
}
\arguments{
\item{x}{matrix or dataframe with three columns
\enumerate{
\item vertex label (integer)
\item vertex label (integer)
\item edge weights (float)
}}

\item{similarity}{string, the name of the similarity metric used to
update weights}

\item{iter}{integer, number of iterations}

\item{k}{integer, maximum length of random walk}
}
\value{
list
\describe{
\item{weights}{A vector of the updated edge weights}
\item{adj}{Updated adjacency matrix containing updated weights}
}
}
\description{
Sharpens the weights of a weighted graph for later pruning.
}
\section{Details}{

Internally, the edgelist passed to \code{rwclust} is converted
into a transition matrix, whose powers are used to compute the
probability of reaching a vertex \eqn{u} from vertex \eqn{v} in
\eqn{k} steps for all \eqn{v} and \eqn{u}. New edge weights are computed
using the similarity between these "walk probabilities" for each pair
of vertices. The intuition is that vertices who have similar
neighborhoods in terms of random walk reachability are similar
to each other.

The returned weights can be used for clustering by deleting
edges with weights below a certain threshold. The connected
components of the resulting graph form the clusters.
}

\references{
Harel, David, and Yehuda Koren. "On clustering using random walks."
International Conference on Foundations of Software Technology
and Theoretical Computer Science. Springer, Berlin, Heidelberg, 2001.
}
