#' @description Simple and fast tool for transforming phytosociological vegetation data into digital form for the following analysis.
#' For detailed guide run \code{vignette("Rveg","Rveg")}
#' or check the quick start guide on <https://github.com/sesitcsl2/Rveg>
#'
#'
#' @references
#'
#'
#'  Danihelka, Chrtek, and Kaplan (2012, ISSN:00327786), "Checklist of vascular plants of the czech republic. Preslia".
#'
#'  Hennekens, and Schaminée (2001) <doi:10.2307/3237010>, "TURBOVEG, a comprehensive data base management system for vegetation data. Journal of Vegetation Science".
#'
#'  Tichý (2002) <doi:10.1111/j.1654-1103.2002.tb02069.x>, "JUICE, software for vegetation classification. Journal of Vegetation Science".
#'
#'  Wickham, François, Henry, Müller (2022) <https://CRAN.R-project.org/package=dplyr>, "dplyr: A Grammar of Data Manipulation".
#'
#' @keywords internal



"_PACKAGE"
## usethis namespace: start
#' @importFrom utils read.csv
#' @importFrom utils read.delim
#' @importFrom utils write.csv
#' @importFrom utils write.table
## usethis namespace: end
NULL

