% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations.update.merge.R
\name{organizations.update.merge}
\alias{organizations.update.merge}
\title{Merge two organizations}
\usage{
organizations.update.merge(id, merge_with_id, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the organization that will be merged}

\item{merge_with_id}{ID of the organization that the organization will be merged with}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Merge two organizations on pipedrive.
}
\examples{
\donttest{
organizations.update.merge(id='e.g.',merge_with_id='e.g.',api_token='token',company_domain='exp')
}
}
