% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.find.R
\name{users.find}
\alias{users.find}
\title{Find users by name}
\usage{
users.find(term, search_by_email = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{term}{Search term to look for}

\item{search_by_email}{When enabled, term will only be matched against email addresses of users. Default: false This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Find users by name from pipedrive.
}
\examples{
\donttest{
users.find(term='e.g.',api_token='token',company_domain='exp')
}
}
