% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.add.R
\name{files.add}
\alias{files.add}
\title{Add file}
\usage{
files.add(file, deal_id = NULL, person_id = NULL, org_id = NULL,
  product_id = NULL, activity_id = NULL, note_id = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{file}{Path and name of file that you want to upload. The default path is work directory.}

\item{deal_id}{ID of the deal to associate file(s) with.}

\item{person_id}{ID of the person to associate file(s) with.}

\item{org_id}{ID of the organization to associate file(s) with.}

\item{product_id}{ID of the product to associate file(s) with.}

\item{activity_id}{ID of the activity to associate file(s) with.}

\item{note_id}{ID of the note to associate file(s) with.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add file on pipedrive.
}
\examples{
\donttest{
files.add(file='e.g.',api_token='token',company_domain='exp')
}
}
