% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cryst1.R
\name{cryst1}
\alias{cryst1}
\alias{cryst1.default}
\alias{is.cryst1}
\title{Create \sQuote{cryst1} Object}
\usage{
cryst1(...)

\method{cryst1}{default}(abc, abg = c(90, 90, 90), sgroup = "P1", ...)

is.cryst1(x)
}
\arguments{
\item{abc}{a numeric vector of length 3 containing the norms of the lattice
vectors a, b and c.}

\item{abg}{a numeric vector of length 3 containing the angles between the
lattice vectors \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}.}

\item{sgroup}{a character string giving the Hermann-Mauguin symbol of the
space group.}

\item{x}{an R obecjt to be tested.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{cryst1} returns a list of class \sQuote{cryst1} with the
following components: \item{abc}{a numeric vector of length 3 containing the
norms of the lattice vectors a, b and c.} \item{abg}{a numeric vector of
length 3 containing the angles between the lattice vectors \eqn{\alpha},
\eqn{\beta} and \eqn{\gamma}.} \item{sgroup}{a character string giving the
Hermann-Mauguin symbol of the space group.} \cr\cr \code{is.Cryst1} returns
TRUE if \code{x} is an object of class \sQuote{cryst1} and FALSE otherwise.
}
\description{
Create an object of class \sQuote{cryst1} containing the unit cell parameters
and the name of the space group to associate with an object of class 
\sQuote{pdb}.
}
\details{
\code{cryst1} is a generic function to create objects of class 
\sQuote{cryst1}. The purpose of this class is to store CRYST1 records from 
PDB files which contain the unit cell parameters and the name of the space 
group of a molecular system stored in a PDB file. The default method of the 
\code{cryst1} function create an object of class \sQuote{cryst1} from its 
different components, i.e.: \code{abc}, \code{abg} and \code{sgroup}. At 
least \code{abc} has to be specified. \cr\cr \code{is.cryst1} tests if an 
object of class \sQuote{cryst1}, i.e. if it has a \dQuote{class} attribute 
equal to \code{cryst1}.
}
\examples{
x <- cryst1(abc = c(10, 10, 10), abg = c(90,90,90), sgroup = "P1")
is.cryst1(x)
 
}
\seealso{
\code{\link{cell.coords}}, \code{\link{pdb}}
}
\keyword{classes}

