\name{C.POSNN.FRST}
\alias{C.POSNN.FRST}
\title{The positive region based fuzzy-rough nearest neighbour algorithm}
\usage{
  C.POSNN.FRST(decision.table, newdata, control = list())
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.  It should be noted
  that the data must be numeric values instead of
  string/char.}

  \item{newdata}{a \code{"DecisionTable"} class
  representing data for the test process.

  See \code{\link{SF.asDecisionTable}}.}

  \item{control}{a list of other parameters which is the
  same as \code{\link{C.FRNN.FRST}}.}
}
\value{
  A matrix of predicted classes of newdata.
}
\description{
  It is a function used to implement the positive region
  based fuzzy-rough nearest neighbour algorithm (POSNN)
  which was proposed by (N. Verbiest et al, 2012) for
  predicting classes of new data.
}
\details{
  This method is aimed to improve the fuzzy-rough nearest
  neighbour algorithm (\code{\link{C.FRNN.FRST}}) algorithm
  by considering the fuzzy positive region. Basically the
  following steps are used to classify an instance \eqn{t}:
  \itemize{ \item determine the set of k-nearest neighbour
  of \eqn{t}, \eqn{NN}.  \item assign \eqn{t} to the class
  \eqn{C} for which

  \eqn{\frac{\displaystyle\sum\limits_{x \in NN}
  R(x,t)C(x)POS(x)}{\displaystyle\sum\limits_{x \in NN}
  R(x,t)}}

  is maximal. }
}
\examples{
#############################################################
## In this example, we are using Iris dataset.
## It should be noted that since the values of the decision attribute are strings,
## they should be transformed into numeric values using unclass()
#############################################################
data(iris)
## shuffle the data
set.seed(2)
irisShuffled <- iris[sample(nrow(iris)),]

## transform values of the decision attribute into numerics
irisShuffled[,5] <- unclass(irisShuffled[,5])

## split the data into training and testing data
iris.training <- irisShuffled[1:105,]
iris.testing <- irisShuffled[106:nrow(irisShuffled),1:4]

colnames(iris.training) <- c("Sepal.Length", "Sepal.Width", "Petal.Length",
                       "Petal.Width", "Species")

## convert into the standard decision table
decision.table <- SF.asDecisionTable(dataset = iris.training, decision.attr = 5,
                                     indx.nominal = c(5))
tst.iris <- SF.asDecisionTable(dataset = iris.testing)

## FRNN algorithm using lower/upper approximation: Implicator/tnorm based approach
control <- list(type.LU = "implicator.tnorm", k = 20, t.tnorm = "lukasiewicz",
                type.relation = c("tolerance", "eq.1"), t.implicator = "lukasiewicz")

\dontrun{res.test.POSNN <- C.POSNN.FRST(decision.table = decision.table,
                              newdata = tst.iris, control = control)}
}
\references{
  N. Verbiest, C. Cornelis and R. Jensen, "Fuzzy-rough
  Positive Region Based Nearest Neighbour Classification",
  In Proceedings of the 20th International Conference on
  Fuzzy Systems (FUZZ-IEEE 2012), p. 1961 - 1967 (2012).
}
\seealso{
  \code{\link{C.FRNN.FRST}}, \code{\link{C.FRNN.O.FRST}}
}

