% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocator.R
\name{robyn_allocator}
\alias{robyn_allocator}
\alias{print.robyn_allocator}
\alias{plot.robyn_allocator}
\title{Budget Allocator}
\usage{
robyn_allocator(
  robyn_object = NULL,
  select_build = 0,
  InputCollect = NULL,
  OutputCollect = NULL,
  select_model = NULL,
  json_file = NULL,
  scenario = "max_response",
  total_budget = NULL,
  target_value = NULL,
  date_range = "all",
  channel_constr_low = NULL,
  channel_constr_up = NULL,
  channel_constr_multiplier = 3,
  optim_algo = "SLSQP_AUGLAG",
  maxeval = 1e+05,
  constr_mode = "eq",
  plots = TRUE,
  plot_folder = NULL,
  plot_folder_sub = NULL,
  export = TRUE,
  quiet = FALSE,
  ui = FALSE,
  ...
)

\method{print}{robyn_allocator}(x, ...)

\method{plot}{robyn_allocator}(x, ...)
}
\arguments{
\item{robyn_object}{Character or List. Path of the \code{Robyn.RDS} object
that contains all previous modeling information or the imported list.}

\item{select_build}{Integer. Default to the latest model build. \code{select_build = 0}
selects the initial model. \code{select_build = 1} selects the first refresh model.}

\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{OutputCollect}{List. Containing all model result.
Required when \code{robyn_object} is not provided.}

\item{select_model}{Character. A model \code{SolID}. When \code{robyn_object}
is provided, \code{select_model} defaults to the already selected \code{SolID}. When
\code{robyn_object} is not provided, \code{select_model} must be provided with
\code{InputCollect} and \code{OutputCollect}, and must be one of
\code{OutputCollect$allSolutions}.}

\item{json_file}{Character. JSON file to import previously exported inputs or
recreate a model. To generate this file, use \code{robyn_write()}.
If you didn't export your data in the json file as "raw_data",
\code{dt_input} must be provided; \code{dt_holidays} input is optional.}

\item{scenario}{Character. Accepted options are: \code{"max_response"}, \code{"target_efficiency"}.
Scenario \code{"max_response"} answers the question:
"What's the potential revenue/conversions lift with the same (or custom) spend level
in \code{date_range} and what is the allocation and expected response mix?"
Scenario \code{"target_efficiency"} optimizes ROAS or CPA and answers the question:
"What's the potential revenue/conversions lift and spend levels based on a
\code{target_value} for CPA/ROAS and what is the allocation and expected response mix?"
Deprecated scenario: \code{"max_response_expected_spend"}.}

\item{total_budget}{Numeric. Total marketing budget for all paid channels for the
period in \code{date_range}.}

\item{target_value}{Numeric. When using the scenario \code{"target_efficiency"},
target_value is the desired ROAS or CPA with no upper spend limit. Default is set to 80\% of
initial ROAS or 120\% of initial CPA, when \code{"target_value = NULL"}.}

\item{date_range}{Character. Date(s) to apply adstocked transformations and pick mean spends
per channel. Set one of: "all", "last", or "last_n" (where
n is the last N dates available), date (i.e. "2022-03-27"), or date range
(i.e. \code{c("2022-01-01", "2022-12-31")}). Default to "all".}

\item{channel_constr_low, channel_constr_up}{Numeric vectors. The lower and upper bounds
for each paid media variable when maximizing total media response. For example,
\code{channel_constr_low = 0.7} means minimum spend of the variable is 70% of historical
average, using non-zero spend values, within \code{date_min} and \code{date_max} date range.
Both constrains must be length 1 (same for all values) OR same length and order as
\code{paid_media_spends}. It's not recommended to 'exaggerate' upper bounds, especially
if the new level is way higher than historical level. Lower bound must be >=0.01,
and upper bound should be < 5.}

\item{channel_constr_multiplier}{Numeric. Default to 3. For example, if
\code{channel_constr_low} and \code{channel_constr_up} are 0.8 to 1.2, the range is 0.4.
The allocator will also show the optimum solution for a larger constraint range of
0.4 x 3 = 1.2, or 0.4 to 1.6, to show the optimization potential to support allocation
interpretation and decision.}

\item{optim_algo}{Character. Default to \code{"SLSQP_AUGLAG"}, short for "Sequential Least-Squares
Quadratic Programming" and "Augmented Lagrangian". Alternatively, "\code{"MMA_AUGLAG"},
short for "Methods of Moving Asymptotes". More details see the documentation of
NLopt \href{https://nlopt.readthedocs.io/en/latest/NLopt_Algorithms/}{here}.}

\item{maxeval}{Integer. The maximum iteration of the global optimization algorithm.
Defaults to 100000.}

\item{constr_mode}{Character. Options are \code{"eq"} or \code{"ineq"},
indicating constraints with equality or inequality.}

\item{plots}{Boolean. Generate plots?}

\item{plot_folder}{Character. Path for saving plots and files. Default
to \code{robyn_object} and saves plot in the same directory as \code{robyn_object}.}

\item{plot_folder_sub}{Character. Sub path for saving plots. Will overwrite the
default path with timestamp or, for refresh and allocator, simply overwrite files.}

\item{export}{Boolean. Export outcomes into local files?}

\item{quiet}{Boolean. Keep messages off?}

\item{ui}{Boolean. Save additional outputs for UI usage. List outcome.}

\item{...}{Additional parameters passed to \code{robyn_outputs()}.}

\item{x}{\code{robyn_allocator()} output.}
}
\value{
A list object containing allocator result.

List. Contains optimized allocation results and plots.
}
\description{
\code{robyn_allocator()} function returns a new split of media
variable spends that maximizes the total media response.
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect results
AllocatorCollect <- robyn_allocator(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = "1_2_3",
  scenario = "max_response",
  channel_constr_low = 0.7,
  channel_constr_up = c(1.2, 1.5, 1.5, 1.5, 1.5),
  channel_constr_multiplier = 4,
  date_range = "last_26",
  export = FALSE
)
# Print a summary
print(AllocatorCollect)
# Plot the allocator one-pager
plot(AllocatorCollect)
}
}
