% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap_Edge_distn.R
\name{BootstrapEdgeDistn}
\alias{BootstrapEdgeDistn}
\title{Penalized Partial Correlation Distribution Estimates}
\usage{
BootstrapEdgeDistn(x, L1, vertices = NULL, subset = NULL, B = 500,
  n_b = 0.5, replace = T, seed = NULL, ...)
}
\arguments{
\item{x}{dataset for estimating MRFs. Supplied as data.frame.}

\item{L1}{Regularization penalty for inducing sparsity in networks}

\item{vertices}{Vertices to include in MRF. Must be a subset of names(x)}

\item{subset}{An expression to select a subset of records/rows}

\item{B}{The number of subsamples to draw}

\item{n_b}{The size of the subsamples. May be provided as an integer less than the number of rows in x, or as a proportion.}

\item{replace}{Logical. Is subsampling done with (T) or without (F) replacement.}

\item{seed}{Random seed value for reproducibility.}

\item{...}{other arguments to be passed to Rnet().}
}
\value{
A numeric matrix containing the estimated penalized partial correlations corresponding to the MRF edges (column) in each subsample (row).
}
\description{
Estimates MRFs from bootstrapped subsamples of data to approximate penalized partial correlation distibutions
}
