% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{getCI}
\alias{getCI}
\title{getCI-forestry}
\usage{
getCI(
  object,
  newdata,
  level = 0.95,
  B = 100,
  method = "OOB-conformal",
  noWarning = FALSE
)
}
\arguments{
\item{object}{A `forestry` object.}

\item{newdata}{A set of new observations for which we want to predict the
outcomes and use confidence intervals.}

\item{level}{The confidence level at which we want to make our intervals. Default
is to use .95 which corresponds to 95 percentile confidence intervals.}

\item{B}{Number of bootstrap draws to use when using method = "OOB-bootstrap"}

\item{method}{A flag for the different ways to create the confidence intervals.
Right now we have two ways of doing this. One is the `OOB-bootstrap` flag which
uses many bootstrap pulls from the set of OOB trees then with these different
pulls, we use the set of trees to predict for the new feature and give the
confidence set over the many bootstrap draws. The other method- `OOB-conformal`-
creates intervals by taking the set of doubleOOB trees for each observation, and
using the predictions of these trees to give conformal intervals. So for an
observation obs_i, let S_i be the set of trees for which obs_i was in neither
the splitting set nor the averaging set (or the set of trees for which obs_i
was "doubleOOB"), we then predict for obs_i with only the trees in S_i.
doubleOOB_tree_preds <- predict(S_i, obs_i):
Then CI(obs_i, alpha = .95) = quantile(doubleOOB_tree_preds - y_i, probs = .95).
The `local-conformal` option takes the residuals of each training point (using)
OOB predictions, and then uses the weights of the random forest to determine
the quantiles of the residuals in the local neighborhood of the predicted point.
Default is `OOB-conformal`.}

\item{noWarning}{flag to not display warnings}
}
\value{
The confidence intervals for each observation in newdata.
}
\description{
For a new set of features, calculate the confidence intervals
 for each new observation.
}
