% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{condAIC}
\alias{condAIC}
\title{Conditional AIC (cAIC)}
\usage{
condAIC(X, Z, y, theta, Delta, V, VCNs, nObs, verbose = TRUE)
}
\arguments{
\item{X}{A \eqn{n \times K}{n by K} dimensional (design) matrix.}

\item{Z}{A\eqn{n \times Jp}{n by J*p} dimensional block-diagonal design matrix.
Each j-th block (\eqn{j = 1,\dots,J}{j = 1,..,J}) is a \eqn{n_j \times p}{n_j by p} dimensional design matrix for the j-th clone.}

\item{y}{n-dimensional vector of the time-adjacent cellular increments}

\item{theta}{p-dimensional vector parameter.}

\item{Delta}{covariance matrix of the random effects u}

\item{V}{A \eqn{p \times K}{p by K} dimensional net-effect matrix.}

\item{VCNs}{A n-dimensional vector including values of the vector copy number corresponding to the cell counts of y.}

\item{nObs}{A K-dimensional vector including the frequencies of each clone k (\eqn{k = 1,\dots,K}{k = 1,..,K}).}

\item{verbose}{(defaults to TRUE) Logical value. If TRUE, then information messages on the progress of
the algorithm are printed to the console.}
}
\value{
Conditional AIC (cAIC) of the conditional log-likelihood \eqn{l(y \vert u)}{l(y|u)} of y given the random effects u.
}
\description{
Conditional AIC (cAIC) of the conditional log-likelihood \eqn{l(y \vert u)}{l(y|u)} of y given the random effects u
}
\keyword{internal}
