/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml.esc;

import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriterBase;
import java.io.IOException;
import java.io.Writer;

public final class XMLEscapeWriterASCII
extends XMLEscapeWriterBase
implements XMLEscapeWriter {
    private static final String ENCODING = "ASCII";

    public XMLEscapeWriterASCII(Writer writer) throws NullPointerException {
        super(writer, ENCODING);
    }

    public void writeAttValue(char[] ch, int off, int len) throws IOException {
        int c = 32;
        for (int i = off; i < off + len; ++i) {
            c = ch[i];
            if (c == 60) {
                this.w.write("&lt;");
                continue;
            }
            if (c == 62) {
                this.w.write("&gt;");
                continue;
            }
            if (c == 38) {
                this.w.write("&amp;");
                continue;
            }
            if (c == 34) {
                this.w.write("&quot;");
                continue;
            }
            if (c == 39) {
                this.w.write("&apos;");
                continue;
            }
            if (c > 255) {
                this.w.write("&#" + c + ";");
                continue;
            }
            if (c == 10 || c == 13 || c == 9) {
                this.w.write(c);
                continue;
            }
            if (c < 32) {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            if (c >= 127 && c < 160) {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            this.w.write(c);
        }
    }

    public void writeText(char c) throws IOException {
        if (c == '<') {
            this.w.write("&lt;");
        } else if (c == '>') {
            this.w.write("&gt;");
        } else if (c == '&') {
            this.w.write("&amp;");
        } else if (c == '\"') {
            this.w.write("&quot;");
        } else if (c == '\'') {
            this.w.write("&apos;");
        } else if (c > '\u00ff') {
            this.w.write("&#" + c + ";");
        } else if (c == '\n' || c == '\r' || c == '\t') {
            this.w.write(c);
        } else if (c < ' ') {
            XMLEscapeWriterASCII.doNothing();
        } else if (c >= '\u007f' && c < '\u00a0') {
            XMLEscapeWriterASCII.doNothing();
        } else {
            this.w.write(c);
        }
    }

    private static void doNothing() {
    }
}

