/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.model.styles.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<T> {
    private static Logger log = LoggerFactory.getLogger(Tree.class);
    private Node<T> rootElement;
    protected Map<String, Object> nodes = new HashMap<String, Object>();

    public Node<T> get(String name) {
        return (Node)this.nodes.get(name);
    }

    public Node<T> getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Node<T> rootElement) {
        this.rootElement = rootElement;
        this.nodes.put(rootElement.name, rootElement);
    }

    public List<Node<T>> toList() {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        this.walk(this.rootElement, list);
        return list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Node<T> n : this.toList()) {
            sb.append(n.name + "\n");
        }
        return sb.toString();
    }

    private void walk(Node<T> element, List<Node<T>> list) {
        if (element == null) {
            return;
        }
        list.add(element);
        for (Node<T> data : element.getChildren()) {
            this.walk(data, list);
        }
    }

    public List<Node<T>> climb(Node<T> n) {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        this.climb(n, list);
        return list;
    }

    private List<Node<T>> climb(Node<T> n, List<Node<T>> list) {
        list.add(n);
        if (n.equals(this.rootElement)) {
            return list;
        }
        Node<T> parent = n.getParent();
        if (parent == null) {
            return list;
        }
        this.climb(parent, list);
        return list;
    }
}

